package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RestoreFromClusterSnapshotResponse(
    cluster: Option[zio.aws.redshift.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotResponse = {
    import RestoreFromClusterSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.RestoreFromClusterSnapshotResponse.ReadOnly =
    zio.aws.redshift.model.RestoreFromClusterSnapshotResponse
      .wrap(buildAwsValue())
}
object RestoreFromClusterSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.RestoreFromClusterSnapshotResponse =
      zio.aws.redshift.model.RestoreFromClusterSnapshotResponse(
        cluster.map(value => value.asEditable)
      )
    def cluster: Option[zio.aws.redshift.model.Cluster.ReadOnly]
    def getCluster
        : ZIO[Any, AwsError, zio.aws.redshift.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotResponse
  ) extends zio.aws.redshift.model.RestoreFromClusterSnapshotResponse.ReadOnly {
    override val cluster: Option[zio.aws.redshift.model.Cluster.ReadOnly] =
      scala
        .Option(impl.cluster())
        .map(value => zio.aws.redshift.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotResponse
  ): zio.aws.redshift.model.RestoreFromClusterSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
