package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{Integer, TStamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ReservedNodeExchangeStatus(
    reservedNodeExchangeRequestId: Option[String] = None,
    status: Option[zio.aws.redshift.model.ReservedNodeExchangeStatusType] =
      None,
    requestTime: Option[TStamp] = None,
    sourceReservedNodeId: Option[String] = None,
    sourceReservedNodeType: Option[String] = None,
    sourceReservedNodeCount: Option[Integer] = None,
    targetReservedNodeOfferingId: Option[String] = None,
    targetReservedNodeType: Option[String] = None,
    targetReservedNodeCount: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeStatus = {
    import ReservedNodeExchangeStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeStatus
      .builder()
      .optionallyWith(
        reservedNodeExchangeRequestId.map(value => value: java.lang.String)
      )(_.reservedNodeExchangeRequestId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(requestTime.map(value => TStamp.unwrap(value): Instant))(
        _.requestTime
      )
      .optionallyWith(
        sourceReservedNodeId.map(value => value: java.lang.String)
      )(_.sourceReservedNodeId)
      .optionallyWith(
        sourceReservedNodeType.map(value => value: java.lang.String)
      )(_.sourceReservedNodeType)
      .optionallyWith(
        sourceReservedNodeCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.sourceReservedNodeCount)
      .optionallyWith(
        targetReservedNodeOfferingId.map(value => value: java.lang.String)
      )(_.targetReservedNodeOfferingId)
      .optionallyWith(
        targetReservedNodeType.map(value => value: java.lang.String)
      )(_.targetReservedNodeType)
      .optionallyWith(
        targetReservedNodeCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.targetReservedNodeCount)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ReservedNodeExchangeStatus.ReadOnly =
    zio.aws.redshift.model.ReservedNodeExchangeStatus.wrap(buildAwsValue())
}
object ReservedNodeExchangeStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ReservedNodeExchangeStatus =
      zio.aws.redshift.model.ReservedNodeExchangeStatus(
        reservedNodeExchangeRequestId.map(value => value),
        status.map(value => value),
        requestTime.map(value => value),
        sourceReservedNodeId.map(value => value),
        sourceReservedNodeType.map(value => value),
        sourceReservedNodeCount.map(value => value),
        targetReservedNodeOfferingId.map(value => value),
        targetReservedNodeType.map(value => value),
        targetReservedNodeCount.map(value => value)
      )
    def reservedNodeExchangeRequestId: Option[String]
    def status: Option[zio.aws.redshift.model.ReservedNodeExchangeStatusType]
    def requestTime: Option[TStamp]
    def sourceReservedNodeId: Option[String]
    def sourceReservedNodeType: Option[String]
    def sourceReservedNodeCount: Option[Integer]
    def targetReservedNodeOfferingId: Option[String]
    def targetReservedNodeType: Option[String]
    def targetReservedNodeCount: Option[Integer]
    def getReservedNodeExchangeRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedNodeExchangeRequestId",
        reservedNodeExchangeRequestId
      )
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ReservedNodeExchangeStatusType
    ] = AwsError.unwrapOptionField("status", status)
    def getRequestTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("requestTime", requestTime)
    def getSourceReservedNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceReservedNodeId", sourceReservedNodeId)
    def getSourceReservedNodeType: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("sourceReservedNodeType", sourceReservedNodeType)
    def getSourceReservedNodeCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("sourceReservedNodeCount", sourceReservedNodeCount)
    def getTargetReservedNodeOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "targetReservedNodeOfferingId",
        targetReservedNodeOfferingId
      )
    def getTargetReservedNodeType: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("targetReservedNodeType", targetReservedNodeType)
    def getTargetReservedNodeCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("targetReservedNodeCount", targetReservedNodeCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeStatus
  ) extends zio.aws.redshift.model.ReservedNodeExchangeStatus.ReadOnly {
    override val reservedNodeExchangeRequestId: Option[String] = scala
      .Option(impl.reservedNodeExchangeRequestId())
      .map(value => value: String)
    override val status
        : Option[zio.aws.redshift.model.ReservedNodeExchangeStatusType] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.redshift.model.ReservedNodeExchangeStatusType.wrap(value)
      )
    override val requestTime: Option[TStamp] = scala
      .Option(impl.requestTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val sourceReservedNodeId: Option[String] =
      scala.Option(impl.sourceReservedNodeId()).map(value => value: String)
    override val sourceReservedNodeType: Option[String] =
      scala.Option(impl.sourceReservedNodeType()).map(value => value: String)
    override val sourceReservedNodeCount: Option[Integer] = scala
      .Option(impl.sourceReservedNodeCount())
      .map(value => zio.aws.redshift.model.primitives.Integer(value))
    override val targetReservedNodeOfferingId: Option[String] = scala
      .Option(impl.targetReservedNodeOfferingId())
      .map(value => value: String)
    override val targetReservedNodeType: Option[String] =
      scala.Option(impl.targetReservedNodeType()).map(value => value: String)
    override val targetReservedNodeCount: Option[Integer] = scala
      .Option(impl.targetReservedNodeCount())
      .map(value => zio.aws.redshift.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeStatus
  ): zio.aws.redshift.model.ReservedNodeExchangeStatus.ReadOnly = new Wrapper(
    impl
  )
}
