package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.{BooleanOptional, IntegerOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetClusterCredentialsRequest(
    dbUser: String,
    dbName: Option[String] = None,
    clusterIdentifier: String,
    durationSeconds: Option[IntegerOptional] = None,
    autoCreate: Option[BooleanOptional] = None,
    dbGroups: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest = {
    import GetClusterCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest
      .builder()
      .dbUser(dbUser: java.lang.String)
      .optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName)
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .optionallyWith(
        durationSeconds.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.durationSeconds)
      .optionallyWith(
        autoCreate.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.autoCreate)
      .optionallyWith(
        dbGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dbGroups)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.GetClusterCredentialsRequest.ReadOnly =
    zio.aws.redshift.model.GetClusterCredentialsRequest.wrap(buildAwsValue())
}
object GetClusterCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.GetClusterCredentialsRequest =
      zio.aws.redshift.model.GetClusterCredentialsRequest(
        dbUser,
        dbName.map(value => value),
        clusterIdentifier,
        durationSeconds.map(value => value),
        autoCreate.map(value => value),
        dbGroups.map(value => value)
      )
    def dbUser: String
    def dbName: Option[String]
    def clusterIdentifier: String
    def durationSeconds: Option[IntegerOptional]
    def autoCreate: Option[BooleanOptional]
    def dbGroups: Option[List[String]]
    def getDbUser: ZIO[Any, Nothing, String] = ZIO.succeed(dbUser)
    def getDbName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getDurationSeconds: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
    def getAutoCreate: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("autoCreate", autoCreate)
    def getDbGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("dbGroups", dbGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest
  ) extends zio.aws.redshift.model.GetClusterCredentialsRequest.ReadOnly {
    override val dbUser: String = impl.dbUser(): String
    override val dbName: Option[String] =
      scala.Option(impl.dbName()).map(value => value: String)
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val durationSeconds: Option[IntegerOptional] = scala
      .Option(impl.durationSeconds())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
    override val autoCreate: Option[BooleanOptional] = scala
      .Option(impl.autoCreate())
      .map(value => zio.aws.redshift.model.primitives.BooleanOptional(value))
    override val dbGroups: Option[List[String]] = scala
      .Option(impl.dbGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest
  ): zio.aws.redshift.model.GetClusterCredentialsRequest.ReadOnly = new Wrapper(
    impl
  )
}
