package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeNodeConfigurationOptionsRequest(
    actionType: zio.aws.redshift.model.ActionType,
    clusterIdentifier: Option[String] = None,
    snapshotIdentifier: Option[String] = None,
    ownerAccount: Option[String] = None,
    filters: Option[
      Iterable[zio.aws.redshift.model.NodeConfigurationOptionsFilter]
    ] = None,
    marker: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest = {
    import DescribeNodeConfigurationOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest
      .builder()
      .actionType(actionType.unwrap)
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(snapshotIdentifier.map(value => value: java.lang.String))(
        _.snapshotIdentifier
      )
      .optionallyWith(ownerAccount.map(value => value: java.lang.String))(
        _.ownerAccount
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeNodeConfigurationOptionsRequest.ReadOnly =
    zio.aws.redshift.model.DescribeNodeConfigurationOptionsRequest
      .wrap(buildAwsValue())
}
object DescribeNodeConfigurationOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeNodeConfigurationOptionsRequest =
      zio.aws.redshift.model.DescribeNodeConfigurationOptionsRequest(
        actionType,
        clusterIdentifier.map(value => value),
        snapshotIdentifier.map(value => value),
        ownerAccount.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value),
        maxRecords.map(value => value)
      )
    def actionType: zio.aws.redshift.model.ActionType
    def clusterIdentifier: Option[String]
    def snapshotIdentifier: Option[String]
    def ownerAccount: Option[String]
    def filters: Option[
      List[zio.aws.redshift.model.NodeConfigurationOptionsFilter.ReadOnly]
    ]
    def marker: Option[String]
    def maxRecords: Option[IntegerOptional]
    def getActionType: ZIO[Any, Nothing, zio.aws.redshift.model.ActionType] =
      ZIO.succeed(actionType)
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotIdentifier", snapshotIdentifier)
    def getOwnerAccount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.NodeConfigurationOptionsFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest
  ) extends zio.aws.redshift.model.DescribeNodeConfigurationOptionsRequest.ReadOnly {
    override val actionType: zio.aws.redshift.model.ActionType =
      zio.aws.redshift.model.ActionType.wrap(impl.actionType())
    override val clusterIdentifier: Option[String] =
      scala.Option(impl.clusterIdentifier()).map(value => value: String)
    override val snapshotIdentifier: Option[String] =
      scala.Option(impl.snapshotIdentifier()).map(value => value: String)
    override val ownerAccount: Option[String] =
      scala.Option(impl.ownerAccount()).map(value => value: String)
    override val filters: Option[
      List[zio.aws.redshift.model.NodeConfigurationOptionsFilter.ReadOnly]
    ] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.NodeConfigurationOptionsFilter.wrap(item)
        }.toList
      )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest
  ): zio.aws.redshift.model.DescribeNodeConfigurationOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
