package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateEventSubscriptionRequest(
    subscriptionName: String,
    snsTopicArn: String,
    sourceType: Option[String] = None,
    sourceIds: Option[Iterable[String]] = None,
    eventCategories: Option[Iterable[String]] = None,
    severity: Option[String] = None,
    enabled: Option[BooleanOptional] = None,
    tags: Option[Iterable[zio.aws.redshift.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionRequest = {
    import CreateEventSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionRequest
      .builder()
      .subscriptionName(subscriptionName: java.lang.String)
      .snsTopicArn(snsTopicArn: java.lang.String)
      .optionallyWith(sourceType.map(value => value: java.lang.String))(
        _.sourceType
      )
      .optionallyWith(
        sourceIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sourceIds)
      .optionallyWith(
        eventCategories.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategories)
      .optionallyWith(severity.map(value => value: java.lang.String))(
        _.severity
      )
      .optionallyWith(
        enabled.map(value => BooleanOptional.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateEventSubscriptionRequest.ReadOnly =
    zio.aws.redshift.model.CreateEventSubscriptionRequest.wrap(buildAwsValue())
}
object CreateEventSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateEventSubscriptionRequest =
      zio.aws.redshift.model.CreateEventSubscriptionRequest(
        subscriptionName,
        snsTopicArn,
        sourceType.map(value => value),
        sourceIds.map(value => value),
        eventCategories.map(value => value),
        severity.map(value => value),
        enabled.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def subscriptionName: String
    def snsTopicArn: String
    def sourceType: Option[String]
    def sourceIds: Option[List[String]]
    def eventCategories: Option[List[String]]
    def severity: Option[String]
    def enabled: Option[BooleanOptional]
    def tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getSubscriptionName: ZIO[Any, Nothing, String] =
      ZIO.succeed(subscriptionName)
    def getSnsTopicArn: ZIO[Any, Nothing, String] = ZIO.succeed(snsTopicArn)
    def getSourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getSourceIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sourceIds", sourceIds)
    def getEventCategories: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategories", eventCategories)
    def getSeverity: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("severity", severity)
    def getEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionRequest
  ) extends zio.aws.redshift.model.CreateEventSubscriptionRequest.ReadOnly {
    override val subscriptionName: String = impl.subscriptionName(): String
    override val snsTopicArn: String = impl.snsTopicArn(): String
    override val sourceType: Option[String] =
      scala.Option(impl.sourceType()).map(value => value: String)
    override val sourceIds: Option[List[String]] = scala
      .Option(impl.sourceIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val eventCategories: Option[List[String]] = scala
      .Option(impl.eventCategories())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val severity: Option[String] =
      scala.Option(impl.severity()).map(value => value: String)
    override val enabled: Option[BooleanOptional] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.redshift.model.primitives.BooleanOptional(value))
    override val tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionRequest
  ): zio.aws.redshift.model.CreateEventSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
