package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{Integer, TStamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class AuthorizeEndpointAccessResponse(
    grantor: Option[String] = None,
    grantee: Option[String] = None,
    clusterIdentifier: Option[String] = None,
    authorizeTime: Option[TStamp] = None,
    clusterStatus: Option[String] = None,
    status: Option[zio.aws.redshift.model.AuthorizationStatus] = None,
    allowedAllVPCs: Option[Boolean] = None,
    allowedVPCs: Option[Iterable[String]] = None,
    endpointCount: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AuthorizeEndpointAccessResponse = {
    import AuthorizeEndpointAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AuthorizeEndpointAccessResponse
      .builder()
      .optionallyWith(grantor.map(value => value: java.lang.String))(_.grantor)
      .optionallyWith(grantee.map(value => value: java.lang.String))(_.grantee)
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(
        authorizeTime.map(value => TStamp.unwrap(value): Instant)
      )(_.authorizeTime)
      .optionallyWith(clusterStatus.map(value => value: java.lang.String))(
        _.clusterStatus
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(allowedAllVPCs.map(value => value: java.lang.Boolean))(
        _.allowedAllVPCs
      )
      .optionallyWith(
        allowedVPCs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.allowedVPCs)
      .optionallyWith(
        endpointCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.endpointCount)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.AuthorizeEndpointAccessResponse.ReadOnly =
    zio.aws.redshift.model.AuthorizeEndpointAccessResponse.wrap(buildAwsValue())
}
object AuthorizeEndpointAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AuthorizeEndpointAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.AuthorizeEndpointAccessResponse =
      zio.aws.redshift.model.AuthorizeEndpointAccessResponse(
        grantor.map(value => value),
        grantee.map(value => value),
        clusterIdentifier.map(value => value),
        authorizeTime.map(value => value),
        clusterStatus.map(value => value),
        status.map(value => value),
        allowedAllVPCs.map(value => value),
        allowedVPCs.map(value => value),
        endpointCount.map(value => value)
      )
    def grantor: Option[String]
    def grantee: Option[String]
    def clusterIdentifier: Option[String]
    def authorizeTime: Option[TStamp]
    def clusterStatus: Option[String]
    def status: Option[zio.aws.redshift.model.AuthorizationStatus]
    def allowedAllVPCs: Option[Boolean]
    def allowedVPCs: Option[List[String]]
    def endpointCount: Option[Integer]
    def getGrantor: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("grantor", grantor)
    def getGrantee: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("grantee", grantee)
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getAuthorizeTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("authorizeTime", authorizeTime)
    def getClusterStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterStatus", clusterStatus)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.redshift.model.AuthorizationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getAllowedAllVPCs: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allowedAllVPCs", allowedAllVPCs)
    def getAllowedVPCs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("allowedVPCs", allowedVPCs)
    def getEndpointCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("endpointCount", endpointCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AuthorizeEndpointAccessResponse
  ) extends zio.aws.redshift.model.AuthorizeEndpointAccessResponse.ReadOnly {
    override val grantor: Option[String] =
      scala.Option(impl.grantor()).map(value => value: String)
    override val grantee: Option[String] =
      scala.Option(impl.grantee()).map(value => value: String)
    override val clusterIdentifier: Option[String] =
      scala.Option(impl.clusterIdentifier()).map(value => value: String)
    override val authorizeTime: Option[TStamp] = scala
      .Option(impl.authorizeTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val clusterStatus: Option[String] =
      scala.Option(impl.clusterStatus()).map(value => value: String)
    override val status: Option[zio.aws.redshift.model.AuthorizationStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.redshift.model.AuthorizationStatus.wrap(value))
    override val allowedAllVPCs: Option[Boolean] =
      scala.Option(impl.allowedAllVPCs()).map(value => value: Boolean)
    override val allowedVPCs: Option[List[String]] = scala
      .Option(impl.allowedVPCs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val endpointCount: Option[Integer] = scala
      .Option(impl.endpointCount())
      .map(value => zio.aws.redshift.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AuthorizeEndpointAccessResponse
  ): zio.aws.redshift.model.AuthorizeEndpointAccessResponse.ReadOnly =
    new Wrapper(impl)
}
