package zio.aws.redshift.model
import scala.jdk.CollectionConverters.*
sealed trait ReservedNodeExchangeActionType {
  def unwrap: software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeActionType
}
object ReservedNodeExchangeActionType {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeActionType
  ): zio.aws.redshift.model.ReservedNodeExchangeActionType = value match {
    case software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeActionType.RESTORE_CLUSTER =>
      val r = `restore-cluster`
      r
    case software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeActionType.RESIZE_CLUSTER =>
      val r = `resize-cluster`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshift.model.ReservedNodeExchangeActionType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeActionType =
      software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object `restore-cluster`
      extends zio.aws.redshift.model.ReservedNodeExchangeActionType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeActionType =
      software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeActionType.RESTORE_CLUSTER
  }
  case object `resize-cluster`
      extends zio.aws.redshift.model.ReservedNodeExchangeActionType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeActionType =
      software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeActionType.RESIZE_CLUSTER
  }
}
