package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.TStamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CreateScheduledActionResponse(
    scheduledActionName: Option[String] = None,
    targetAction: Option[zio.aws.redshift.model.ScheduledActionType] = None,
    schedule: Option[String] = None,
    iamRole: Option[String] = None,
    scheduledActionDescription: Option[String] = None,
    state: Option[zio.aws.redshift.model.ScheduledActionState] = None,
    nextInvocations: Option[Iterable[TStamp]] = None,
    startTime: Option[TStamp] = None,
    endTime: Option[TStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateScheduledActionResponse = {
    import CreateScheduledActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateScheduledActionResponse
      .builder()
      .optionallyWith(
        scheduledActionName.map(value => value: java.lang.String)
      )(_.scheduledActionName)
      .optionallyWith(targetAction.map(value => value.buildAwsValue()))(
        _.targetAction
      )
      .optionallyWith(schedule.map(value => value: java.lang.String))(
        _.schedule
      )
      .optionallyWith(iamRole.map(value => value: java.lang.String))(_.iamRole)
      .optionallyWith(
        scheduledActionDescription.map(value => value: java.lang.String)
      )(_.scheduledActionDescription)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        nextInvocations.map(value =>
          value.map { item =>
            TStamp.unwrap(item): Instant
          }.asJavaCollection
        )
      )(_.nextInvocations)
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => TStamp.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateScheduledActionResponse.ReadOnly =
    zio.aws.redshift.model.CreateScheduledActionResponse.wrap(buildAwsValue())
}
object CreateScheduledActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateScheduledActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateScheduledActionResponse =
      zio.aws.redshift.model.CreateScheduledActionResponse(
        scheduledActionName.map(value => value),
        targetAction.map(value => value.asEditable),
        schedule.map(value => value),
        iamRole.map(value => value),
        scheduledActionDescription.map(value => value),
        state.map(value => value),
        nextInvocations.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def scheduledActionName: Option[String]
    def targetAction
        : Option[zio.aws.redshift.model.ScheduledActionType.ReadOnly]
    def schedule: Option[String]
    def iamRole: Option[String]
    def scheduledActionDescription: Option[String]
    def state: Option[zio.aws.redshift.model.ScheduledActionState]
    def nextInvocations: Option[List[TStamp]]
    def startTime: Option[TStamp]
    def endTime: Option[TStamp]
    def getScheduledActionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scheduledActionName", scheduledActionName)
    def getTargetAction: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ScheduledActionType.ReadOnly
    ] = AwsError.unwrapOptionField("targetAction", targetAction)
    def getSchedule: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getIamRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("iamRole", iamRole)
    def getScheduledActionDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "scheduledActionDescription",
        scheduledActionDescription
      )
    def getState
        : ZIO[Any, AwsError, zio.aws.redshift.model.ScheduledActionState] =
      AwsError.unwrapOptionField("state", state)
    def getNextInvocations: ZIO[Any, AwsError, List[TStamp]] =
      AwsError.unwrapOptionField("nextInvocations", nextInvocations)
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateScheduledActionResponse
  ) extends zio.aws.redshift.model.CreateScheduledActionResponse.ReadOnly {
    override val scheduledActionName: Option[String] =
      scala.Option(impl.scheduledActionName()).map(value => value: String)
    override val targetAction
        : Option[zio.aws.redshift.model.ScheduledActionType.ReadOnly] = scala
      .Option(impl.targetAction())
      .map(value => zio.aws.redshift.model.ScheduledActionType.wrap(value))
    override val schedule: Option[String] =
      scala.Option(impl.schedule()).map(value => value: String)
    override val iamRole: Option[String] =
      scala.Option(impl.iamRole()).map(value => value: String)
    override val scheduledActionDescription: Option[String] = scala
      .Option(impl.scheduledActionDescription())
      .map(value => value: String)
    override val state: Option[zio.aws.redshift.model.ScheduledActionState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.redshift.model.ScheduledActionState.wrap(value))
    override val nextInvocations: Option[List[TStamp]] = scala
      .Option(impl.nextInvocations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.primitives.TStamp(item)
        }.toList
      )
    override val startTime: Option[TStamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val endTime: Option[TStamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateScheduledActionResponse
  ): zio.aws.redshift.model.CreateScheduledActionResponse.ReadOnly =
    new Wrapper(impl)
}
