package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AquaConfiguration(
    aquaStatus: Option[zio.aws.redshift.model.AquaStatus] = None,
    aquaConfigurationStatus: Option[
      zio.aws.redshift.model.AquaConfigurationStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AquaConfiguration = {
    import AquaConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AquaConfiguration
      .builder()
      .optionallyWith(aquaStatus.map(value => value.unwrap))(_.aquaStatus)
      .optionallyWith(aquaConfigurationStatus.map(value => value.unwrap))(
        _.aquaConfigurationStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.AquaConfiguration.ReadOnly =
    zio.aws.redshift.model.AquaConfiguration.wrap(buildAwsValue())
}
object AquaConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AquaConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.AquaConfiguration =
      zio.aws.redshift.model.AquaConfiguration(
        aquaStatus.map(value => value),
        aquaConfigurationStatus.map(value => value)
      )
    def aquaStatus: Option[zio.aws.redshift.model.AquaStatus]
    def aquaConfigurationStatus
        : Option[zio.aws.redshift.model.AquaConfigurationStatus]
    def getAquaStatus: ZIO[Any, AwsError, zio.aws.redshift.model.AquaStatus] =
      AwsError.unwrapOptionField("aquaStatus", aquaStatus)
    def getAquaConfigurationStatus
        : ZIO[Any, AwsError, zio.aws.redshift.model.AquaConfigurationStatus] =
      AwsError.unwrapOptionField(
        "aquaConfigurationStatus",
        aquaConfigurationStatus
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AquaConfiguration
  ) extends zio.aws.redshift.model.AquaConfiguration.ReadOnly {
    override val aquaStatus: Option[zio.aws.redshift.model.AquaStatus] = scala
      .Option(impl.aquaStatus())
      .map(value => zio.aws.redshift.model.AquaStatus.wrap(value))
    override val aquaConfigurationStatus
        : Option[zio.aws.redshift.model.AquaConfigurationStatus] = scala
      .Option(impl.aquaConfigurationStatus())
      .map(value => zio.aws.redshift.model.AquaConfigurationStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AquaConfiguration
  ): zio.aws.redshift.model.AquaConfiguration.ReadOnly = new Wrapper(impl)
}
