package zio.aws.redshift.model
import scala.jdk.CollectionConverters.*
sealed trait ScheduledActionTypeValues {
  def unwrap
      : software.amazon.awssdk.services.redshift.model.ScheduledActionTypeValues
}
object ScheduledActionTypeValues {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.ScheduledActionTypeValues
  ): zio.aws.redshift.model.ScheduledActionTypeValues = value match {
    case software.amazon.awssdk.services.redshift.model.ScheduledActionTypeValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.ScheduledActionTypeValues.RESIZE_CLUSTER =>
      val r = ResizeCluster
      r
    case software.amazon.awssdk.services.redshift.model.ScheduledActionTypeValues.PAUSE_CLUSTER =>
      val r = PauseCluster
      r
    case software.amazon.awssdk.services.redshift.model.ScheduledActionTypeValues.RESUME_CLUSTER =>
      val r = ResumeCluster
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshift.model.ScheduledActionTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ScheduledActionTypeValues =
      software.amazon.awssdk.services.redshift.model.ScheduledActionTypeValues.UNKNOWN_TO_SDK_VERSION
  }
  case object ResizeCluster
      extends zio.aws.redshift.model.ScheduledActionTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ScheduledActionTypeValues =
      software.amazon.awssdk.services.redshift.model.ScheduledActionTypeValues.RESIZE_CLUSTER
  }
  case object PauseCluster
      extends zio.aws.redshift.model.ScheduledActionTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ScheduledActionTypeValues =
      software.amazon.awssdk.services.redshift.model.ScheduledActionTypeValues.PAUSE_CLUSTER
  }
  case object ResumeCluster
      extends zio.aws.redshift.model.ScheduledActionTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ScheduledActionTypeValues =
      software.amazon.awssdk.services.redshift.model.ScheduledActionTypeValues.RESUME_CLUSTER
  }
}
