package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.{BooleanOptional, IntegerOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResizeClusterMessage(
    clusterIdentifier: String,
    clusterType: Option[String] = None,
    nodeType: Option[String] = None,
    numberOfNodes: Option[IntegerOptional] = None,
    classic: Option[BooleanOptional] = None,
    reservedNodeId: Option[String] = None,
    targetReservedNodeOfferingId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ResizeClusterMessage = {
    import ResizeClusterMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ResizeClusterMessage
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .optionallyWith(clusterType.map(value => value: java.lang.String))(
        _.clusterType
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(
        numberOfNodes.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.numberOfNodes)
      .optionallyWith(
        classic.map(value => BooleanOptional.unwrap(value): java.lang.Boolean)
      )(_.classic)
      .optionallyWith(reservedNodeId.map(value => value: java.lang.String))(
        _.reservedNodeId
      )
      .optionallyWith(
        targetReservedNodeOfferingId.map(value => value: java.lang.String)
      )(_.targetReservedNodeOfferingId)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ResizeClusterMessage.ReadOnly =
    zio.aws.redshift.model.ResizeClusterMessage.wrap(buildAwsValue())
}
object ResizeClusterMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ResizeClusterMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ResizeClusterMessage =
      zio.aws.redshift.model.ResizeClusterMessage(
        clusterIdentifier,
        clusterType.map(value => value),
        nodeType.map(value => value),
        numberOfNodes.map(value => value),
        classic.map(value => value),
        reservedNodeId.map(value => value),
        targetReservedNodeOfferingId.map(value => value)
      )
    def clusterIdentifier: String
    def clusterType: Option[String]
    def nodeType: Option[String]
    def numberOfNodes: Option[IntegerOptional]
    def classic: Option[BooleanOptional]
    def reservedNodeId: Option[String]
    def targetReservedNodeOfferingId: Option[String]
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getClusterType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterType", clusterType)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getNumberOfNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
    def getClassic: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("classic", classic)
    def getReservedNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedNodeId", reservedNodeId)
    def getTargetReservedNodeOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "targetReservedNodeOfferingId",
        targetReservedNodeOfferingId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ResizeClusterMessage
  ) extends zio.aws.redshift.model.ResizeClusterMessage.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val clusterType: Option[String] =
      scala.Option(impl.clusterType()).map(value => value: String)
    override val nodeType: Option[String] =
      scala.Option(impl.nodeType()).map(value => value: String)
    override val numberOfNodes: Option[IntegerOptional] = scala
      .Option(impl.numberOfNodes())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
    override val classic: Option[BooleanOptional] = scala
      .Option(impl.classic())
      .map(value => zio.aws.redshift.model.primitives.BooleanOptional(value))
    override val reservedNodeId: Option[String] =
      scala.Option(impl.reservedNodeId()).map(value => value: String)
    override val targetReservedNodeOfferingId: Option[String] = scala
      .Option(impl.targetReservedNodeOfferingId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ResizeClusterMessage
  ): zio.aws.redshift.model.ResizeClusterMessage.ReadOnly = new Wrapper(impl)
}
