package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyClusterMaintenanceResponse(
    cluster: Option[zio.aws.redshift.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceResponse = {
    import ModifyClusterMaintenanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifyClusterMaintenanceResponse.ReadOnly =
    zio.aws.redshift.model.ModifyClusterMaintenanceResponse
      .wrap(buildAwsValue())
}
object ModifyClusterMaintenanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyClusterMaintenanceResponse =
      zio.aws.redshift.model.ModifyClusterMaintenanceResponse(
        cluster.map(value => value.asEditable)
      )
    def cluster: Option[zio.aws.redshift.model.Cluster.ReadOnly]
    def getCluster
        : ZIO[Any, AwsError, zio.aws.redshift.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceResponse
  ) extends zio.aws.redshift.model.ModifyClusterMaintenanceResponse.ReadOnly {
    override val cluster: Option[zio.aws.redshift.model.Cluster.ReadOnly] =
      scala
        .Option(impl.cluster())
        .map(value => zio.aws.redshift.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceResponse
  ): zio.aws.redshift.model.ModifyClusterMaintenanceResponse.ReadOnly =
    new Wrapper(impl)
}
