package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateClusterSnapshotResponse(
    snapshot: Option[zio.aws.redshift.model.Snapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotResponse = {
    import CreateClusterSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateClusterSnapshotResponse.ReadOnly =
    zio.aws.redshift.model.CreateClusterSnapshotResponse.wrap(buildAwsValue())
}
object CreateClusterSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateClusterSnapshotResponse =
      zio.aws.redshift.model
        .CreateClusterSnapshotResponse(snapshot.map(value => value.asEditable))
    def snapshot: Option[zio.aws.redshift.model.Snapshot.ReadOnly]
    def getSnapshot
        : ZIO[Any, AwsError, zio.aws.redshift.model.Snapshot.ReadOnly] =
      AwsError.unwrapOptionField("snapshot", snapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotResponse
  ) extends zio.aws.redshift.model.CreateClusterSnapshotResponse.ReadOnly {
    override val snapshot: Option[zio.aws.redshift.model.Snapshot.ReadOnly] =
      scala
        .Option(impl.snapshot())
        .map(value => zio.aws.redshift.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotResponse
  ): zio.aws.redshift.model.CreateClusterSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
