package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AuthorizeClusterSecurityGroupIngressRequest(
    clusterSecurityGroupName: String,
    cidrip: Option[String] = None,
    ec2SecurityGroupName: Option[String] = None,
    ec2SecurityGroupOwnerId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest = {
    import AuthorizeClusterSecurityGroupIngressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest
      .builder()
      .clusterSecurityGroupName(clusterSecurityGroupName: java.lang.String)
      .optionallyWith(cidrip.map(value => value: java.lang.String))(_.cidrip)
      .optionallyWith(
        ec2SecurityGroupName.map(value => value: java.lang.String)
      )(_.ec2SecurityGroupName)
      .optionallyWith(
        ec2SecurityGroupOwnerId.map(value => value: java.lang.String)
      )(_.ec2SecurityGroupOwnerId)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressRequest.ReadOnly =
    zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressRequest
      .wrap(buildAwsValue())
}
object AuthorizeClusterSecurityGroupIngressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressRequest =
      zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressRequest(
        clusterSecurityGroupName,
        cidrip.map(value => value),
        ec2SecurityGroupName.map(value => value),
        ec2SecurityGroupOwnerId.map(value => value)
      )
    def clusterSecurityGroupName: String
    def cidrip: Option[String]
    def ec2SecurityGroupName: Option[String]
    def ec2SecurityGroupOwnerId: Option[String]
    def getClusterSecurityGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterSecurityGroupName)
    def getCidrip: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrip", cidrip)
    def getEc2SecurityGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2SecurityGroupName", ec2SecurityGroupName)
    def getEc2SecurityGroupOwnerId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("ec2SecurityGroupOwnerId", ec2SecurityGroupOwnerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest
  ) extends zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressRequest.ReadOnly {
    override val clusterSecurityGroupName: String =
      impl.clusterSecurityGroupName(): String
    override val cidrip: Option[String] =
      scala.Option(impl.cidrip()).map(value => value: String)
    override val ec2SecurityGroupName: Option[String] =
      scala.Option(impl.ec2SecurityGroupName()).map(value => value: String)
    override val ec2SecurityGroupOwnerId: Option[String] =
      scala.Option(impl.ec2SecurityGroupOwnerId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest
  ): zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressRequest.ReadOnly =
    new Wrapper(impl)
}
