package zio.aws.redshift.model
import scala.jdk.CollectionConverters.*
sealed trait SourceType {
  def unwrap: software.amazon.awssdk.services.redshift.model.SourceType
}
object SourceType {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.SourceType
  ): zio.aws.redshift.model.SourceType = value match {
    case software.amazon.awssdk.services.redshift.model.SourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.SourceType.CLUSTER =>
      val r = cluster
      r
    case software.amazon.awssdk.services.redshift.model.SourceType.CLUSTER_PARAMETER_GROUP =>
      val r = `cluster-parameter-group`
      r
    case software.amazon.awssdk.services.redshift.model.SourceType.CLUSTER_SECURITY_GROUP =>
      val r = `cluster-security-group`
      r
    case software.amazon.awssdk.services.redshift.model.SourceType.CLUSTER_SNAPSHOT =>
      val r = `cluster-snapshot`
      r
    case software.amazon.awssdk.services.redshift.model.SourceType.SCHEDULED_ACTION =>
      val r = `scheduled-action`
      r
  }
  case object unknownToSdkVersion extends zio.aws.redshift.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.SourceType =
      software.amazon.awssdk.services.redshift.model.SourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object cluster extends zio.aws.redshift.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.SourceType =
      software.amazon.awssdk.services.redshift.model.SourceType.CLUSTER
  }
  case object `cluster-parameter-group`
      extends zio.aws.redshift.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.SourceType =
      software.amazon.awssdk.services.redshift.model.SourceType.CLUSTER_PARAMETER_GROUP
  }
  case object `cluster-security-group`
      extends zio.aws.redshift.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.SourceType =
      software.amazon.awssdk.services.redshift.model.SourceType.CLUSTER_SECURITY_GROUP
  }
  case object `cluster-snapshot` extends zio.aws.redshift.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.SourceType =
      software.amazon.awssdk.services.redshift.model.SourceType.CLUSTER_SNAPSHOT
  }
  case object `scheduled-action` extends zio.aws.redshift.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.SourceType =
      software.amazon.awssdk.services.redshift.model.SourceType.SCHEDULED_ACTION
  }
}
