package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RotateEncryptionKeyResponse(
    cluster: Option[zio.aws.redshift.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.RotateEncryptionKeyResponse = {
    import RotateEncryptionKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.RotateEncryptionKeyResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.RotateEncryptionKeyResponse.ReadOnly =
    zio.aws.redshift.model.RotateEncryptionKeyResponse.wrap(buildAwsValue())
}
object RotateEncryptionKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.RotateEncryptionKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.RotateEncryptionKeyResponse =
      zio.aws.redshift.model
        .RotateEncryptionKeyResponse(cluster.map(value => value.asEditable))
    def cluster: Option[zio.aws.redshift.model.Cluster.ReadOnly]
    def getCluster
        : ZIO[Any, AwsError, zio.aws.redshift.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.RotateEncryptionKeyResponse
  ) extends zio.aws.redshift.model.RotateEncryptionKeyResponse.ReadOnly {
    override val cluster: Option[zio.aws.redshift.model.Cluster.ReadOnly] =
      scala
        .Option(impl.cluster())
        .map(value => zio.aws.redshift.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.RotateEncryptionKeyResponse
  ): zio.aws.redshift.model.RotateEncryptionKeyResponse.ReadOnly = new Wrapper(
    impl
  )
}
