package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TaggedResource(
    tag: Option[zio.aws.redshift.model.Tag] = None,
    resourceName: Option[String] = None,
    resourceType: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.TaggedResource = {
    import TaggedResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.TaggedResource
      .builder()
      .optionallyWith(tag.map(value => value.buildAwsValue()))(_.tag)
      .optionallyWith(resourceName.map(value => value: java.lang.String))(
        _.resourceName
      )
      .optionallyWith(resourceType.map(value => value: java.lang.String))(
        _.resourceType
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.TaggedResource.ReadOnly =
    zio.aws.redshift.model.TaggedResource.wrap(buildAwsValue())
}
object TaggedResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.TaggedResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.TaggedResource =
      zio.aws.redshift.model.TaggedResource(
        tag.map(value => value.asEditable),
        resourceName.map(value => value),
        resourceType.map(value => value)
      )
    def tag: Option[zio.aws.redshift.model.Tag.ReadOnly]
    def resourceName: Option[String]
    def resourceType: Option[String]
    def getTag: ZIO[Any, AwsError, zio.aws.redshift.model.Tag.ReadOnly] =
      AwsError.unwrapOptionField("tag", tag)
    def getResourceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getResourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.TaggedResource
  ) extends zio.aws.redshift.model.TaggedResource.ReadOnly {
    override val tag: Option[zio.aws.redshift.model.Tag.ReadOnly] = scala
      .Option(impl.tag())
      .map(value => zio.aws.redshift.model.Tag.wrap(value))
    override val resourceName: Option[String] =
      scala.Option(impl.resourceName()).map(value => value: String)
    override val resourceType: Option[String] =
      scala.Option(impl.resourceType()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.TaggedResource
  ): zio.aws.redshift.model.TaggedResource.ReadOnly = new Wrapper(impl)
}
