package zio.aws.redshift.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{
  IntegerOptional,
  BooleanOptional,
  TStamp
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeScheduledActionsRequest(
    scheduledActionName: Option[String] = None,
    targetActionType: Option[zio.aws.redshift.model.ScheduledActionTypeValues] =
      None,
    startTime: Option[TStamp] = None,
    endTime: Option[TStamp] = None,
    active: Option[BooleanOptional] = None,
    filters: Option[Iterable[zio.aws.redshift.model.ScheduledActionFilter]] =
      None,
    marker: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsRequest = {
    import DescribeScheduledActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsRequest
      .builder()
      .optionallyWith(
        scheduledActionName.map(value => value: java.lang.String)
      )(_.scheduledActionName)
      .optionallyWith(targetActionType.map(value => value.unwrap))(
        _.targetActionType
      )
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => TStamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        active.map(value => BooleanOptional.unwrap(value): java.lang.Boolean)
      )(_.active)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeScheduledActionsRequest.ReadOnly =
    zio.aws.redshift.model.DescribeScheduledActionsRequest.wrap(buildAwsValue())
}
object DescribeScheduledActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeScheduledActionsRequest =
      zio.aws.redshift.model.DescribeScheduledActionsRequest(
        scheduledActionName.map(value => value),
        targetActionType.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        active.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value),
        maxRecords.map(value => value)
      )
    def scheduledActionName: Option[String]
    def targetActionType
        : Option[zio.aws.redshift.model.ScheduledActionTypeValues]
    def startTime: Option[TStamp]
    def endTime: Option[TStamp]
    def active: Option[BooleanOptional]
    def filters
        : Option[List[zio.aws.redshift.model.ScheduledActionFilter.ReadOnly]]
    def marker: Option[String]
    def maxRecords: Option[IntegerOptional]
    def getScheduledActionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scheduledActionName", scheduledActionName)
    def getTargetActionType
        : ZIO[Any, AwsError, zio.aws.redshift.model.ScheduledActionTypeValues] =
      AwsError.unwrapOptionField("targetActionType", targetActionType)
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getActive: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("active", active)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ScheduledActionFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsRequest
  ) extends zio.aws.redshift.model.DescribeScheduledActionsRequest.ReadOnly {
    override val scheduledActionName: Option[String] =
      scala.Option(impl.scheduledActionName()).map(value => value: String)
    override val targetActionType
        : Option[zio.aws.redshift.model.ScheduledActionTypeValues] = scala
      .Option(impl.targetActionType())
      .map(value =>
        zio.aws.redshift.model.ScheduledActionTypeValues.wrap(value)
      )
    override val startTime: Option[TStamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val endTime: Option[TStamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val active: Option[BooleanOptional] = scala
      .Option(impl.active())
      .map(value => zio.aws.redshift.model.primitives.BooleanOptional(value))
    override val filters
        : Option[List[zio.aws.redshift.model.ScheduledActionFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.ScheduledActionFilter.wrap(item)
          }.toList
        )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsRequest
  ): zio.aws.redshift.model.DescribeScheduledActionsRequest.ReadOnly =
    new Wrapper(impl)
}
