package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CopyClusterSnapshotRequest(
    sourceSnapshotIdentifier: String,
    sourceSnapshotClusterIdentifier: Option[String] = None,
    targetSnapshotIdentifier: String,
    manualSnapshotRetentionPeriod: Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotRequest = {
    import CopyClusterSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotRequest
      .builder()
      .sourceSnapshotIdentifier(sourceSnapshotIdentifier: java.lang.String)
      .optionallyWith(
        sourceSnapshotClusterIdentifier.map(value => value: java.lang.String)
      )(_.sourceSnapshotClusterIdentifier)
      .targetSnapshotIdentifier(targetSnapshotIdentifier: java.lang.String)
      .optionallyWith(
        manualSnapshotRetentionPeriod.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.manualSnapshotRetentionPeriod)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.CopyClusterSnapshotRequest.ReadOnly =
    zio.aws.redshift.model.CopyClusterSnapshotRequest.wrap(buildAwsValue())
}
object CopyClusterSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CopyClusterSnapshotRequest =
      zio.aws.redshift.model.CopyClusterSnapshotRequest(
        sourceSnapshotIdentifier,
        sourceSnapshotClusterIdentifier.map(value => value),
        targetSnapshotIdentifier,
        manualSnapshotRetentionPeriod.map(value => value)
      )
    def sourceSnapshotIdentifier: String
    def sourceSnapshotClusterIdentifier: Option[String]
    def targetSnapshotIdentifier: String
    def manualSnapshotRetentionPeriod: Option[IntegerOptional]
    def getSourceSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceSnapshotIdentifier)
    def getSourceSnapshotClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "sourceSnapshotClusterIdentifier",
        sourceSnapshotClusterIdentifier
      )
    def getTargetSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetSnapshotIdentifier)
    def getManualSnapshotRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "manualSnapshotRetentionPeriod",
        manualSnapshotRetentionPeriod
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotRequest
  ) extends zio.aws.redshift.model.CopyClusterSnapshotRequest.ReadOnly {
    override val sourceSnapshotIdentifier: String =
      impl.sourceSnapshotIdentifier(): String
    override val sourceSnapshotClusterIdentifier: Option[String] = scala
      .Option(impl.sourceSnapshotClusterIdentifier())
      .map(value => value: String)
    override val targetSnapshotIdentifier: String =
      impl.targetSnapshotIdentifier(): String
    override val manualSnapshotRetentionPeriod: Option[IntegerOptional] = scala
      .Option(impl.manualSnapshotRetentionPeriod())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotRequest
  ): zio.aws.redshift.model.CopyClusterSnapshotRequest.ReadOnly = new Wrapper(
    impl
  )
}
