package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyClusterIamRolesRequest(
    clusterIdentifier: String,
    addIamRoles: Option[Iterable[String]] = None,
    removeIamRoles: Option[Iterable[String]] = None,
    defaultIamRoleArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesRequest = {
    import ModifyClusterIamRolesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesRequest
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .optionallyWith(
        addIamRoles.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.addIamRoles)
      .optionallyWith(
        removeIamRoles.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.removeIamRoles)
      .optionallyWith(defaultIamRoleArn.map(value => value: java.lang.String))(
        _.defaultIamRoleArn
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ModifyClusterIamRolesRequest.ReadOnly =
    zio.aws.redshift.model.ModifyClusterIamRolesRequest.wrap(buildAwsValue())
}
object ModifyClusterIamRolesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyClusterIamRolesRequest =
      zio.aws.redshift.model.ModifyClusterIamRolesRequest(
        clusterIdentifier,
        addIamRoles.map(value => value),
        removeIamRoles.map(value => value),
        defaultIamRoleArn.map(value => value)
      )
    def clusterIdentifier: String
    def addIamRoles: Option[List[String]]
    def removeIamRoles: Option[List[String]]
    def defaultIamRoleArn: Option[String]
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getAddIamRoles: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("addIamRoles", addIamRoles)
    def getRemoveIamRoles: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("removeIamRoles", removeIamRoles)
    def getDefaultIamRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultIamRoleArn", defaultIamRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesRequest
  ) extends zio.aws.redshift.model.ModifyClusterIamRolesRequest.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val addIamRoles: Option[List[String]] = scala
      .Option(impl.addIamRoles())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val removeIamRoles: Option[List[String]] = scala
      .Option(impl.removeIamRoles())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val defaultIamRoleArn: Option[String] =
      scala.Option(impl.defaultIamRoleArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesRequest
  ): zio.aws.redshift.model.ModifyClusterIamRolesRequest.ReadOnly = new Wrapper(
    impl
  )
}
