package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AuthorizeDataShareRequest(
    dataShareArn: String,
    consumerIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AuthorizeDataShareRequest = {
    import AuthorizeDataShareRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AuthorizeDataShareRequest
      .builder()
      .dataShareArn(dataShareArn: java.lang.String)
      .consumerIdentifier(consumerIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.AuthorizeDataShareRequest.ReadOnly =
    zio.aws.redshift.model.AuthorizeDataShareRequest.wrap(buildAwsValue())
}
object AuthorizeDataShareRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AuthorizeDataShareRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.AuthorizeDataShareRequest =
      zio.aws.redshift.model
        .AuthorizeDataShareRequest(dataShareArn, consumerIdentifier)
    def dataShareArn: String
    def consumerIdentifier: String
    def getDataShareArn: ZIO[Any, Nothing, String] = ZIO.succeed(dataShareArn)
    def getConsumerIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(consumerIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AuthorizeDataShareRequest
  ) extends zio.aws.redshift.model.AuthorizeDataShareRequest.ReadOnly {
    override val dataShareArn: String = impl.dataShareArn(): String
    override val consumerIdentifier: String = impl.consumerIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AuthorizeDataShareRequest
  ): zio.aws.redshift.model.AuthorizeDataShareRequest.ReadOnly = new Wrapper(
    impl
  )
}
