package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDataSharesResponse(
    dataShares: Option[Iterable[zio.aws.redshift.model.DataShare]] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeDataSharesResponse = {
    import DescribeDataSharesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeDataSharesResponse
      .builder()
      .optionallyWith(
        dataShares.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataShares)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DescribeDataSharesResponse.ReadOnly =
    zio.aws.redshift.model.DescribeDataSharesResponse.wrap(buildAwsValue())
}
object DescribeDataSharesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeDataSharesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeDataSharesResponse =
      zio.aws.redshift.model.DescribeDataSharesResponse(
        dataShares.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def dataShares: Option[List[zio.aws.redshift.model.DataShare.ReadOnly]]
    def marker: Option[String]
    def getDataShares
        : ZIO[Any, AwsError, List[zio.aws.redshift.model.DataShare.ReadOnly]] =
      AwsError.unwrapOptionField("dataShares", dataShares)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeDataSharesResponse
  ) extends zio.aws.redshift.model.DescribeDataSharesResponse.ReadOnly {
    override val dataShares
        : Option[List[zio.aws.redshift.model.DataShare.ReadOnly]] = scala
      .Option(impl.dataShares())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.DataShare.wrap(item)
        }.toList
      )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeDataSharesResponse
  ): zio.aws.redshift.model.DescribeDataSharesResponse.ReadOnly = new Wrapper(
    impl
  )
}
