package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeClusterVersionsResponse(
    marker: Option[String] = None,
    clusterVersions: Option[Iterable[zio.aws.redshift.model.ClusterVersion]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse = {
    import DescribeClusterVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        clusterVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterVersions)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeClusterVersionsResponse.ReadOnly =
    zio.aws.redshift.model.DescribeClusterVersionsResponse.wrap(buildAwsValue())
}
object DescribeClusterVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeClusterVersionsResponse =
      zio.aws.redshift.model.DescribeClusterVersionsResponse(
        marker.map(value => value),
        clusterVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def clusterVersions
        : Option[List[zio.aws.redshift.model.ClusterVersion.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getClusterVersions: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ClusterVersion.ReadOnly
    ]] = AwsError.unwrapOptionField("clusterVersions", clusterVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse
  ) extends zio.aws.redshift.model.DescribeClusterVersionsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val clusterVersions
        : Option[List[zio.aws.redshift.model.ClusterVersion.ReadOnly]] = scala
      .Option(impl.clusterVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.ClusterVersion.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse
  ): zio.aws.redshift.model.DescribeClusterVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
