package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeClusterSecurityGroupsResponse(
    marker: Option[String] = None,
    clusterSecurityGroups: Option[
      Iterable[zio.aws.redshift.model.ClusterSecurityGroup]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse = {
    import DescribeClusterSecurityGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        clusterSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterSecurityGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeClusterSecurityGroupsResponse.ReadOnly =
    zio.aws.redshift.model.DescribeClusterSecurityGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeClusterSecurityGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeClusterSecurityGroupsResponse =
      zio.aws.redshift.model.DescribeClusterSecurityGroupsResponse(
        marker.map(value => value),
        clusterSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def clusterSecurityGroups
        : Option[List[zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getClusterSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly
    ]] =
      AwsError.unwrapOptionField("clusterSecurityGroups", clusterSecurityGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse
  ) extends zio.aws.redshift.model.DescribeClusterSecurityGroupsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val clusterSecurityGroups
        : Option[List[zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly]] =
      scala
        .Option(impl.clusterSecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.ClusterSecurityGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse
  ): zio.aws.redshift.model.DescribeClusterSecurityGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
