package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeClusterTracksResponse(
    maintenanceTracks: Option[
      Iterable[zio.aws.redshift.model.MaintenanceTrack]
    ] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse = {
    import DescribeClusterTracksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse
      .builder()
      .optionallyWith(
        maintenanceTracks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.maintenanceTracks)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeClusterTracksResponse.ReadOnly =
    zio.aws.redshift.model.DescribeClusterTracksResponse.wrap(buildAwsValue())
}
object DescribeClusterTracksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeClusterTracksResponse =
      zio.aws.redshift.model.DescribeClusterTracksResponse(
        maintenanceTracks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def maintenanceTracks
        : Option[List[zio.aws.redshift.model.MaintenanceTrack.ReadOnly]]
    def marker: Option[String]
    def getMaintenanceTracks: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.MaintenanceTrack.ReadOnly
    ]] = AwsError.unwrapOptionField("maintenanceTracks", maintenanceTracks)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse
  ) extends zio.aws.redshift.model.DescribeClusterTracksResponse.ReadOnly {
    override val maintenanceTracks
        : Option[List[zio.aws.redshift.model.MaintenanceTrack.ReadOnly]] = scala
      .Option(impl.maintenanceTracks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.MaintenanceTrack.wrap(item)
        }.toList
      )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse
  ): zio.aws.redshift.model.DescribeClusterTracksResponse.ReadOnly =
    new Wrapper(impl)
}
