package zio.aws.redshift.model
import scala.jdk.CollectionConverters.*
sealed trait AuthorizationStatus {
  def unwrap: software.amazon.awssdk.services.redshift.model.AuthorizationStatus
}
object AuthorizationStatus {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.AuthorizationStatus
  ): zio.aws.redshift.model.AuthorizationStatus = value match {
    case software.amazon.awssdk.services.redshift.model.AuthorizationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.AuthorizationStatus.AUTHORIZED =>
      val r = Authorized
      r
    case software.amazon.awssdk.services.redshift.model.AuthorizationStatus.REVOKING =>
      val r = Revoking
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshift.model.AuthorizationStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.AuthorizationStatus =
      software.amazon.awssdk.services.redshift.model.AuthorizationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Authorized extends zio.aws.redshift.model.AuthorizationStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.AuthorizationStatus =
      software.amazon.awssdk.services.redshift.model.AuthorizationStatus.AUTHORIZED
  }
  case object Revoking extends zio.aws.redshift.model.AuthorizationStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.AuthorizationStatus =
      software.amazon.awssdk.services.redshift.model.AuthorizationStatus.REVOKING
  }
}
