package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeTableRestoreStatusResponse(
    tableRestoreStatusDetails: Option[
      Iterable[zio.aws.redshift.model.TableRestoreStatus]
    ] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusResponse = {
    import DescribeTableRestoreStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusResponse
      .builder()
      .optionallyWith(
        tableRestoreStatusDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tableRestoreStatusDetails)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeTableRestoreStatusResponse.ReadOnly =
    zio.aws.redshift.model.DescribeTableRestoreStatusResponse
      .wrap(buildAwsValue())
}
object DescribeTableRestoreStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeTableRestoreStatusResponse =
      zio.aws.redshift.model.DescribeTableRestoreStatusResponse(
        tableRestoreStatusDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def tableRestoreStatusDetails
        : Option[List[zio.aws.redshift.model.TableRestoreStatus.ReadOnly]]
    def marker: Option[String]
    def getTableRestoreStatusDetails: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.TableRestoreStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "tableRestoreStatusDetails",
      tableRestoreStatusDetails
    )
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusResponse
  ) extends zio.aws.redshift.model.DescribeTableRestoreStatusResponse.ReadOnly {
    override val tableRestoreStatusDetails
        : Option[List[zio.aws.redshift.model.TableRestoreStatus.ReadOnly]] =
      scala
        .Option(impl.tableRestoreStatusDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.TableRestoreStatus.wrap(item)
          }.toList
        )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusResponse
  ): zio.aws.redshift.model.DescribeTableRestoreStatusResponse.ReadOnly =
    new Wrapper(impl)
}
