package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeClusterParametersRequest(
    parameterGroupName: String,
    source: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest = {
    import DescribeClusterParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest
      .builder()
      .parameterGroupName(parameterGroupName: java.lang.String)
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeClusterParametersRequest.ReadOnly =
    zio.aws.redshift.model.DescribeClusterParametersRequest
      .wrap(buildAwsValue())
}
object DescribeClusterParametersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeClusterParametersRequest =
      zio.aws.redshift.model.DescribeClusterParametersRequest(
        parameterGroupName,
        source.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def parameterGroupName: String
    def source: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupName)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest
  ) extends zio.aws.redshift.model.DescribeClusterParametersRequest.ReadOnly {
    override val parameterGroupName: String = impl.parameterGroupName(): String
    override val source: Option[String] =
      scala.Option(impl.source()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest
  ): zio.aws.redshift.model.DescribeClusterParametersRequest.ReadOnly =
    new Wrapper(impl)
}
