package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSnapshotSchedulesRequest(
    clusterIdentifier: Option[String] = None,
    scheduleIdentifier: Option[String] = None,
    tagKeys: Option[Iterable[String]] = None,
    tagValues: Option[Iterable[String]] = None,
    marker: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest = {
    import DescribeSnapshotSchedulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(scheduleIdentifier.map(value => value: java.lang.String))(
        _.scheduleIdentifier
      )
      .optionallyWith(
        tagKeys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagKeys)
      .optionallyWith(
        tagValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagValues)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeSnapshotSchedulesRequest.ReadOnly =
    zio.aws.redshift.model.DescribeSnapshotSchedulesRequest
      .wrap(buildAwsValue())
}
object DescribeSnapshotSchedulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeSnapshotSchedulesRequest =
      zio.aws.redshift.model.DescribeSnapshotSchedulesRequest(
        clusterIdentifier.map(value => value),
        scheduleIdentifier.map(value => value),
        tagKeys.map(value => value),
        tagValues.map(value => value),
        marker.map(value => value),
        maxRecords.map(value => value)
      )
    def clusterIdentifier: Option[String]
    def scheduleIdentifier: Option[String]
    def tagKeys: Option[List[String]]
    def tagValues: Option[List[String]]
    def marker: Option[String]
    def maxRecords: Option[IntegerOptional]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getScheduleIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scheduleIdentifier", scheduleIdentifier)
    def getTagKeys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagKeys", tagKeys)
    def getTagValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagValues", tagValues)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest
  ) extends zio.aws.redshift.model.DescribeSnapshotSchedulesRequest.ReadOnly {
    override val clusterIdentifier: Option[String] =
      scala.Option(impl.clusterIdentifier()).map(value => value: String)
    override val scheduleIdentifier: Option[String] =
      scala.Option(impl.scheduleIdentifier()).map(value => value: String)
    override val tagKeys: Option[List[String]] = scala
      .Option(impl.tagKeys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tagValues: Option[List[String]] = scala
      .Option(impl.tagValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest
  ): zio.aws.redshift.model.DescribeSnapshotSchedulesRequest.ReadOnly =
    new Wrapper(impl)
}
