package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateClusterSnapshotRequest(
    snapshotIdentifier: String,
    clusterIdentifier: String,
    manualSnapshotRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.redshift.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotRequest = {
    import CreateClusterSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotRequest
      .builder()
      .snapshotIdentifier(snapshotIdentifier: java.lang.String)
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .optionallyWith(
        manualSnapshotRetentionPeriod.map(value => value: Integer)
      )(_.manualSnapshotRetentionPeriod)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.CreateClusterSnapshotRequest.ReadOnly =
    zio.aws.redshift.model.CreateClusterSnapshotRequest.wrap(buildAwsValue())
}
object CreateClusterSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateClusterSnapshotRequest =
      zio.aws.redshift.model.CreateClusterSnapshotRequest(
        snapshotIdentifier,
        clusterIdentifier,
        manualSnapshotRetentionPeriod.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def snapshotIdentifier: String
    def clusterIdentifier: String
    def manualSnapshotRetentionPeriod: Optional[IntegerOptional]
    def tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(snapshotIdentifier)
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getManualSnapshotRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "manualSnapshotRetentionPeriod",
        manualSnapshotRetentionPeriod
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotRequest
  ) extends zio.aws.redshift.model.CreateClusterSnapshotRequest.ReadOnly {
    override val snapshotIdentifier: String = impl.snapshotIdentifier(): String
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val manualSnapshotRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manualSnapshotRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotRequest
  ): zio.aws.redshift.model.CreateClusterSnapshotRequest.ReadOnly = new Wrapper(
    impl
  )
}
