package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetResourcePolicyResponse(
    resourcePolicy: Optional[zio.aws.redshift.model.ResourcePolicy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.GetResourcePolicyResponse = {
    import GetResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.GetResourcePolicyResponse
      .builder()
      .optionallyWith(resourcePolicy.map(value => value.buildAwsValue()))(
        _.resourcePolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.GetResourcePolicyResponse.ReadOnly =
    zio.aws.redshift.model.GetResourcePolicyResponse.wrap(buildAwsValue())
}
object GetResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.GetResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.GetResourcePolicyResponse =
      zio.aws.redshift.model.GetResourcePolicyResponse(
        resourcePolicy.map(value => value.asEditable)
      )
    def resourcePolicy: Optional[zio.aws.redshift.model.ResourcePolicy.ReadOnly]
    def getResourcePolicy
        : ZIO[Any, AwsError, zio.aws.redshift.model.ResourcePolicy.ReadOnly] =
      AwsError.unwrapOptionField("resourcePolicy", resourcePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.GetResourcePolicyResponse
  ) extends zio.aws.redshift.model.GetResourcePolicyResponse.ReadOnly {
    override val resourcePolicy
        : Optional[zio.aws.redshift.model.ResourcePolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourcePolicy())
        .map(value => zio.aws.redshift.model.ResourcePolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.GetResourcePolicyResponse
  ): zio.aws.redshift.model.GetResourcePolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
