package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSnapshotCopyGrantResponse(
    snapshotCopyGrant: Optional[zio.aws.redshift.model.SnapshotCopyGrant] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantResponse = {
    import CreateSnapshotCopyGrantResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantResponse
      .builder()
      .optionallyWith(snapshotCopyGrant.map(value => value.buildAwsValue()))(
        _.snapshotCopyGrant
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateSnapshotCopyGrantResponse.ReadOnly =
    zio.aws.redshift.model.CreateSnapshotCopyGrantResponse.wrap(buildAwsValue())
}
object CreateSnapshotCopyGrantResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateSnapshotCopyGrantResponse =
      zio.aws.redshift.model.CreateSnapshotCopyGrantResponse(
        snapshotCopyGrant.map(value => value.asEditable)
      )
    def snapshotCopyGrant
        : Optional[zio.aws.redshift.model.SnapshotCopyGrant.ReadOnly]
    def getSnapshotCopyGrant: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.SnapshotCopyGrant.ReadOnly
    ] = AwsError.unwrapOptionField("snapshotCopyGrant", snapshotCopyGrant)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantResponse
  ) extends zio.aws.redshift.model.CreateSnapshotCopyGrantResponse.ReadOnly {
    override val snapshotCopyGrant
        : Optional[zio.aws.redshift.model.SnapshotCopyGrant.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotCopyGrant())
        .map(value => zio.aws.redshift.model.SnapshotCopyGrant.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantResponse
  ): zio.aws.redshift.model.CreateSnapshotCopyGrantResponse.ReadOnly =
    new Wrapper(impl)
}
