package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{
  BooleanOptional,
  IntegerOptional,
  SensitiveString
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PendingModifiedValues(
    masterUserPassword: Optional[SensitiveString] = Optional.Absent,
    nodeType: Optional[String] = Optional.Absent,
    numberOfNodes: Optional[IntegerOptional] = Optional.Absent,
    clusterType: Optional[String] = Optional.Absent,
    clusterVersion: Optional[String] = Optional.Absent,
    automatedSnapshotRetentionPeriod: Optional[IntegerOptional] =
      Optional.Absent,
    clusterIdentifier: Optional[String] = Optional.Absent,
    publiclyAccessible: Optional[BooleanOptional] = Optional.Absent,
    enhancedVpcRouting: Optional[BooleanOptional] = Optional.Absent,
    maintenanceTrackName: Optional[String] = Optional.Absent,
    encryptionType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.PendingModifiedValues = {
    import PendingModifiedValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.PendingModifiedValues
      .builder()
      .optionallyWith(
        masterUserPassword.map(value =>
          SensitiveString.unwrap(value): java.lang.String
        )
      )(_.masterUserPassword)
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(numberOfNodes.map(value => value: Integer))(
        _.numberOfNodes
      )
      .optionallyWith(clusterType.map(value => value: java.lang.String))(
        _.clusterType
      )
      .optionallyWith(clusterVersion.map(value => value: java.lang.String))(
        _.clusterVersion
      )
      .optionallyWith(
        automatedSnapshotRetentionPeriod.map(value => value: Integer)
      )(_.automatedSnapshotRetentionPeriod)
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        enhancedVpcRouting.map(value => value: java.lang.Boolean)
      )(_.enhancedVpcRouting)
      .optionallyWith(
        maintenanceTrackName.map(value => value: java.lang.String)
      )(_.maintenanceTrackName)
      .optionallyWith(encryptionType.map(value => value: java.lang.String))(
        _.encryptionType
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.PendingModifiedValues.ReadOnly =
    zio.aws.redshift.model.PendingModifiedValues.wrap(buildAwsValue())
}
object PendingModifiedValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.PendingModifiedValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.PendingModifiedValues =
      zio.aws.redshift.model.PendingModifiedValues(
        masterUserPassword.map(value => value),
        nodeType.map(value => value),
        numberOfNodes.map(value => value),
        clusterType.map(value => value),
        clusterVersion.map(value => value),
        automatedSnapshotRetentionPeriod.map(value => value),
        clusterIdentifier.map(value => value),
        publiclyAccessible.map(value => value),
        enhancedVpcRouting.map(value => value),
        maintenanceTrackName.map(value => value),
        encryptionType.map(value => value)
      )
    def masterUserPassword: Optional[SensitiveString]
    def nodeType: Optional[String]
    def numberOfNodes: Optional[IntegerOptional]
    def clusterType: Optional[String]
    def clusterVersion: Optional[String]
    def automatedSnapshotRetentionPeriod: Optional[IntegerOptional]
    def clusterIdentifier: Optional[String]
    def publiclyAccessible: Optional[BooleanOptional]
    def enhancedVpcRouting: Optional[BooleanOptional]
    def maintenanceTrackName: Optional[String]
    def encryptionType: Optional[String]
    def getMasterUserPassword: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getNumberOfNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
    def getClusterType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterType", clusterType)
    def getClusterVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getAutomatedSnapshotRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "automatedSnapshotRetentionPeriod",
      automatedSnapshotRetentionPeriod
    )
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getEnhancedVpcRouting: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enhancedVpcRouting", enhancedVpcRouting)
    def getMaintenanceTrackName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceTrackName", maintenanceTrackName)
    def getEncryptionType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("encryptionType", encryptionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.PendingModifiedValues
  ) extends zio.aws.redshift.model.PendingModifiedValues.ReadOnly {
    override val masterUserPassword: Optional[SensitiveString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterUserPassword())
        .map(value => zio.aws.redshift.model.primitives.SensitiveString(value))
    override val nodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => value: String)
    override val numberOfNodes: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfNodes())
        .map(value => value: IntegerOptional)
    override val clusterType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterType())
      .map(value => value: String)
    override val clusterVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterVersion())
      .map(value => value: String)
    override val automatedSnapshotRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automatedSnapshotRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val publiclyAccessible: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publiclyAccessible())
        .map(value => value: BooleanOptional)
    override val enhancedVpcRouting: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enhancedVpcRouting())
        .map(value => value: BooleanOptional)
    override val maintenanceTrackName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maintenanceTrackName())
      .map(value => value: String)
    override val encryptionType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.PendingModifiedValues
  ): zio.aws.redshift.model.PendingModifiedValues.ReadOnly = new Wrapper(impl)
}
