package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutResourcePolicyResponse(
    resourcePolicy: Optional[zio.aws.redshift.model.ResourcePolicy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.PutResourcePolicyResponse = {
    import PutResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.PutResourcePolicyResponse
      .builder()
      .optionallyWith(resourcePolicy.map(value => value.buildAwsValue()))(
        _.resourcePolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.PutResourcePolicyResponse.ReadOnly =
    zio.aws.redshift.model.PutResourcePolicyResponse.wrap(buildAwsValue())
}
object PutResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.PutResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.PutResourcePolicyResponse =
      zio.aws.redshift.model.PutResourcePolicyResponse(
        resourcePolicy.map(value => value.asEditable)
      )
    def resourcePolicy: Optional[zio.aws.redshift.model.ResourcePolicy.ReadOnly]
    def getResourcePolicy
        : ZIO[Any, AwsError, zio.aws.redshift.model.ResourcePolicy.ReadOnly] =
      AwsError.unwrapOptionField("resourcePolicy", resourcePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.PutResourcePolicyResponse
  ) extends zio.aws.redshift.model.PutResourcePolicyResponse.ReadOnly {
    override val resourcePolicy
        : Optional[zio.aws.redshift.model.ResourcePolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourcePolicy())
        .map(value => zio.aws.redshift.model.ResourcePolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.PutResourcePolicyResponse
  ): zio.aws.redshift.model.PutResourcePolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
