package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutResourcePolicyRequest(resourceArn: String, policy: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.PutResourcePolicyRequest = {
    import PutResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.PutResourcePolicyRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .policy(policy: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.PutResourcePolicyRequest.ReadOnly =
    zio.aws.redshift.model.PutResourcePolicyRequest.wrap(buildAwsValue())
}
object PutResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.PutResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.PutResourcePolicyRequest =
      zio.aws.redshift.model.PutResourcePolicyRequest(resourceArn, policy)
    def resourceArn: String
    def policy: String
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
    def getPolicy: ZIO[Any, Nothing, String] = ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.PutResourcePolicyRequest
  ) extends zio.aws.redshift.model.PutResourcePolicyRequest.ReadOnly {
    override val resourceArn: String = impl.resourceArn(): String
    override val policy: String = impl.policy(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.PutResourcePolicyRequest
  ): zio.aws.redshift.model.PutResourcePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
