package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeInboundIntegrationsResponse(
    marker: Optional[String] = Optional.Absent,
    inboundIntegrations: Optional[
      Iterable[zio.aws.redshift.model.InboundIntegration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeInboundIntegrationsResponse = {
    import DescribeInboundIntegrationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeInboundIntegrationsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        inboundIntegrations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inboundIntegrations)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeInboundIntegrationsResponse.ReadOnly =
    zio.aws.redshift.model.DescribeInboundIntegrationsResponse
      .wrap(buildAwsValue())
}
object DescribeInboundIntegrationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeInboundIntegrationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeInboundIntegrationsResponse =
      zio.aws.redshift.model.DescribeInboundIntegrationsResponse(
        marker.map(value => value),
        inboundIntegrations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def inboundIntegrations
        : Optional[List[zio.aws.redshift.model.InboundIntegration.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getInboundIntegrations: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.InboundIntegration.ReadOnly
    ]] = AwsError.unwrapOptionField("inboundIntegrations", inboundIntegrations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeInboundIntegrationsResponse
  ) extends zio.aws.redshift.model.DescribeInboundIntegrationsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val inboundIntegrations
        : Optional[List[zio.aws.redshift.model.InboundIntegration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inboundIntegrations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.InboundIntegration.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeInboundIntegrationsResponse
  ): zio.aws.redshift.model.DescribeInboundIntegrationsResponse.ReadOnly =
    new Wrapper(impl)
}
