package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RevokeEndpointAccessRequest(
    clusterIdentifier: Optional[String] = Optional.Absent,
    account: Optional[String] = Optional.Absent,
    vpcIds: Optional[Iterable[String]] = Optional.Absent,
    force: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessRequest = {
    import RevokeEndpointAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessRequest
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(account.map(value => value: java.lang.String))(_.account)
      .optionallyWith(
        vpcIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcIds)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.RevokeEndpointAccessRequest.ReadOnly =
    zio.aws.redshift.model.RevokeEndpointAccessRequest.wrap(buildAwsValue())
}
object RevokeEndpointAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.RevokeEndpointAccessRequest =
      zio.aws.redshift.model.RevokeEndpointAccessRequest(
        clusterIdentifier.map(value => value),
        account.map(value => value),
        vpcIds.map(value => value),
        force.map(value => value)
      )
    def clusterIdentifier: Optional[String]
    def account: Optional[String]
    def vpcIds: Optional[List[String]]
    def force: Optional[Boolean]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getAccount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("account", account)
    def getVpcIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcIds", vpcIds)
    def getForce: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessRequest
  ) extends zio.aws.redshift.model.RevokeEndpointAccessRequest.ReadOnly {
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val account: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.account())
      .map(value => value: String)
    override val vpcIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val force: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.force())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessRequest
  ): zio.aws.redshift.model.RevokeEndpointAccessRequest.ReadOnly = new Wrapper(
    impl
  )
}
