package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetClusterCredentialsWithIamRequest(
    dbName: Optional[String] = Optional.Absent,
    clusterIdentifier: Optional[String] = Optional.Absent,
    durationSeconds: Optional[IntegerOptional] = Optional.Absent,
    customDomainName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamRequest = {
    import GetClusterCredentialsWithIamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamRequest
      .builder()
      .optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName)
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(durationSeconds.map(value => value: Integer))(
        _.durationSeconds
      )
      .optionallyWith(customDomainName.map(value => value: java.lang.String))(
        _.customDomainName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.GetClusterCredentialsWithIamRequest.ReadOnly =
    zio.aws.redshift.model.GetClusterCredentialsWithIamRequest
      .wrap(buildAwsValue())
}
object GetClusterCredentialsWithIamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.GetClusterCredentialsWithIamRequest =
      zio.aws.redshift.model.GetClusterCredentialsWithIamRequest(
        dbName.map(value => value),
        clusterIdentifier.map(value => value),
        durationSeconds.map(value => value),
        customDomainName.map(value => value)
      )
    def dbName: Optional[String]
    def clusterIdentifier: Optional[String]
    def durationSeconds: Optional[IntegerOptional]
    def customDomainName: Optional[String]
    def getDbName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getDurationSeconds: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
    def getCustomDomainName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customDomainName", customDomainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamRequest
  ) extends zio.aws.redshift.model.GetClusterCredentialsWithIamRequest.ReadOnly {
    override val dbName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbName())
      .map(value => value: String)
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val durationSeconds: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationSeconds())
        .map(value => value: IntegerOptional)
    override val customDomainName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.customDomainName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamRequest
  ): zio.aws.redshift.model.GetClusterCredentialsWithIamRequest.ReadOnly =
    new Wrapper(impl)
}
