package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeClusterSecurityGroupsResponse(
    marker: Optional[String] = Optional.Absent,
    clusterSecurityGroups: Optional[
      Iterable[zio.aws.redshift.model.ClusterSecurityGroup]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse = {
    import DescribeClusterSecurityGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        clusterSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterSecurityGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeClusterSecurityGroupsResponse.ReadOnly =
    zio.aws.redshift.model.DescribeClusterSecurityGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeClusterSecurityGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeClusterSecurityGroupsResponse =
      zio.aws.redshift.model.DescribeClusterSecurityGroupsResponse(
        marker.map(value => value),
        clusterSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def clusterSecurityGroups
        : Optional[List[zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getClusterSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly
    ]] =
      AwsError.unwrapOptionField("clusterSecurityGroups", clusterSecurityGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse
  ) extends zio.aws.redshift.model.DescribeClusterSecurityGroupsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val clusterSecurityGroups
        : Optional[List[zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterSecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.ClusterSecurityGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse
  ): zio.aws.redshift.model.DescribeClusterSecurityGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
