package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.AuthenticationProfileNameString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAuthenticationProfileResponse(
    authenticationProfileName: Optional[AuthenticationProfileNameString] =
      Optional.Absent,
    authenticationProfileContent: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateAuthenticationProfileResponse = {
    import CreateAuthenticationProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateAuthenticationProfileResponse
      .builder()
      .optionallyWith(
        authenticationProfileName.map(value =>
          AuthenticationProfileNameString.unwrap(value): java.lang.String
        )
      )(_.authenticationProfileName)
      .optionallyWith(
        authenticationProfileContent.map(value => value: java.lang.String)
      )(_.authenticationProfileContent)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateAuthenticationProfileResponse.ReadOnly =
    zio.aws.redshift.model.CreateAuthenticationProfileResponse
      .wrap(buildAwsValue())
}
object CreateAuthenticationProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateAuthenticationProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateAuthenticationProfileResponse =
      zio.aws.redshift.model.CreateAuthenticationProfileResponse(
        authenticationProfileName.map(value => value),
        authenticationProfileContent.map(value => value)
      )
    def authenticationProfileName: Optional[AuthenticationProfileNameString]
    def authenticationProfileContent: Optional[String]
    def getAuthenticationProfileName
        : ZIO[Any, AwsError, AuthenticationProfileNameString] = AwsError
      .unwrapOptionField("authenticationProfileName", authenticationProfileName)
    def getAuthenticationProfileContent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "authenticationProfileContent",
        authenticationProfileContent
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateAuthenticationProfileResponse
  ) extends zio.aws.redshift.model.CreateAuthenticationProfileResponse.ReadOnly {
    override val authenticationProfileName
        : Optional[AuthenticationProfileNameString] = zio.aws.core.internal
      .optionalFromNullable(impl.authenticationProfileName())
      .map(value =>
        zio.aws.redshift.model.primitives.AuthenticationProfileNameString(value)
      )
    override val authenticationProfileContent: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationProfileContent())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateAuthenticationProfileResponse
  ): zio.aws.redshift.model.CreateAuthenticationProfileResponse.ReadOnly =
    new Wrapper(impl)
}
