package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeHsmClientCertificatesResponse(
    marker: Optional[String] = Optional.Absent,
    hsmClientCertificates: Optional[
      Iterable[zio.aws.redshift.model.HsmClientCertificate]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse = {
    import DescribeHsmClientCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        hsmClientCertificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hsmClientCertificates)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeHsmClientCertificatesResponse.ReadOnly =
    zio.aws.redshift.model.DescribeHsmClientCertificatesResponse
      .wrap(buildAwsValue())
}
object DescribeHsmClientCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeHsmClientCertificatesResponse =
      zio.aws.redshift.model.DescribeHsmClientCertificatesResponse(
        marker.map(value => value),
        hsmClientCertificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def hsmClientCertificates
        : Optional[List[zio.aws.redshift.model.HsmClientCertificate.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getHsmClientCertificates: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.HsmClientCertificate.ReadOnly
    ]] =
      AwsError.unwrapOptionField("hsmClientCertificates", hsmClientCertificates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse
  ) extends zio.aws.redshift.model.DescribeHsmClientCertificatesResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val hsmClientCertificates
        : Optional[List[zio.aws.redshift.model.HsmClientCertificate.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hsmClientCertificates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.HsmClientCertificate.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse
  ): zio.aws.redshift.model.DescribeHsmClientCertificatesResponse.ReadOnly =
    new Wrapper(impl)
}
