package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EventCategoriesMap(
    sourceType: Optional[String] = Optional.Absent,
    events: Optional[Iterable[zio.aws.redshift.model.EventInfoMap]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.EventCategoriesMap = {
    import EventCategoriesMap.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.EventCategoriesMap
      .builder()
      .optionallyWith(sourceType.map(value => value: java.lang.String))(
        _.sourceType
      )
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.EventCategoriesMap.ReadOnly =
    zio.aws.redshift.model.EventCategoriesMap.wrap(buildAwsValue())
}
object EventCategoriesMap {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.EventCategoriesMap
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.EventCategoriesMap =
      zio.aws.redshift.model.EventCategoriesMap(
        sourceType.map(value => value),
        events.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceType: Optional[String]
    def events: Optional[List[zio.aws.redshift.model.EventInfoMap.ReadOnly]]
    def getSourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getEvents: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.EventInfoMap.ReadOnly
    ]] = AwsError.unwrapOptionField("events", events)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.EventCategoriesMap
  ) extends zio.aws.redshift.model.EventCategoriesMap.ReadOnly {
    override val sourceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceType())
      .map(value => value: String)
    override val events
        : Optional[List[zio.aws.redshift.model.EventInfoMap.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.events())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.EventInfoMap.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.EventCategoriesMap
  ): zio.aws.redshift.model.EventCategoriesMap.ReadOnly = new Wrapper(impl)
}
