package zio.aws.redshift
import zio.aws.redshift.model.primitives.TStamp
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.redshift.model.primitives.PartnerIntegrationClusterIdentifier.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AuthenticationProfileNameString extends Subtype[String]
    type AuthenticationProfileNameString =
      zio.aws.redshift.model.primitives.AuthenticationProfileNameString.Type
    type BooleanOptional = Boolean
    object CustomDomainCertificateArnString extends Subtype[String]
    type CustomDomainCertificateArnString =
      zio.aws.redshift.model.primitives.CustomDomainCertificateArnString.Type
    object CustomDomainNameString extends Subtype[String]
    type CustomDomainNameString =
      zio.aws.redshift.model.primitives.CustomDomainNameString.Type
    type DoubleOptional = Double
    type Integer = Int
    type IntegerOptional = Int
    type LongOptional = Long
    object PartnerIntegrationAccountId extends Subtype[String]
    type PartnerIntegrationAccountId =
      zio.aws.redshift.model.primitives.PartnerIntegrationAccountId.Type
    object PartnerIntegrationClusterIdentifier extends Subtype[String]
    type PartnerIntegrationClusterIdentifier =
      zio.aws.redshift.model.primitives.PartnerIntegrationClusterIdentifier.Type
    object PartnerIntegrationDatabaseName extends Subtype[String]
    type PartnerIntegrationDatabaseName =
      zio.aws.redshift.model.primitives.PartnerIntegrationDatabaseName.Type
    object PartnerIntegrationPartnerName extends Subtype[String]
    type PartnerIntegrationPartnerName =
      zio.aws.redshift.model.primitives.PartnerIntegrationPartnerName.Type
    object PartnerIntegrationStatusMessage extends Subtype[String]
    type PartnerIntegrationStatusMessage =
      zio.aws.redshift.model.primitives.PartnerIntegrationStatusMessage.Type
    object SensitiveString extends Subtype[String]
    type SensitiveString =
      zio.aws.redshift.model.primitives.SensitiveString.Type
    object TStamp extends Subtype[Instant]
    type TStamp = zio.aws.redshift.model.primitives.TStamp.Type
  }
  type AccountsWithRestoreAccessList =
    List[zio.aws.redshift.model.AccountWithRestoreAccess]
  type AssociatedClusterList =
    List[zio.aws.redshift.model.ClusterAssociatedToSchedule]
  type AssociationList = List[zio.aws.redshift.model.Association]
  type AttributeList = List[zio.aws.redshift.model.AccountAttribute]
  type AttributeNameList = List[String]
  type AttributeValueList = List[zio.aws.redshift.model.AttributeValueTarget]
  type AuthenticationProfileList =
    List[zio.aws.redshift.model.AuthenticationProfile]
  type AvailabilityZoneList = List[zio.aws.redshift.model.AvailabilityZone]
  type BatchSnapshotOperationErrorList =
    List[zio.aws.redshift.model.SnapshotErrorMessage]
  type BatchSnapshotOperationErrors =
    List[zio.aws.redshift.model.SnapshotErrorMessage]
  type CertificateAssociationList =
    List[zio.aws.redshift.model.CertificateAssociation]
  type ClusterDbRevisionsList = List[zio.aws.redshift.model.ClusterDbRevision]
  type ClusterIamRoleList = List[zio.aws.redshift.model.ClusterIamRole]
  type ClusterList = List[zio.aws.redshift.model.Cluster]
  type ClusterNodesList = List[zio.aws.redshift.model.ClusterNode]
  type ClusterParameterGroupStatusList =
    List[zio.aws.redshift.model.ClusterParameterGroupStatus]
  type ClusterParameterStatusList =
    List[zio.aws.redshift.model.ClusterParameterStatus]
  type ClusterSecurityGroupMembershipList =
    List[zio.aws.redshift.model.ClusterSecurityGroupMembership]
  type ClusterSecurityGroupNameList = List[String]
  type ClusterSecurityGroups = List[zio.aws.redshift.model.ClusterSecurityGroup]
  type ClusterSubnetGroups = List[zio.aws.redshift.model.ClusterSubnetGroup]
  type ClusterVersionList = List[zio.aws.redshift.model.ClusterVersion]
  type DataShareAssociationList =
    List[zio.aws.redshift.model.DataShareAssociation]
  type DataShareList = List[zio.aws.redshift.model.DataShare]
  type DbGroupList = List[String]
  type DeferredMaintenanceWindowsList =
    List[zio.aws.redshift.model.DeferredMaintenanceWindow]
  type DeleteClusterSnapshotMessageList =
    List[zio.aws.redshift.model.DeleteClusterSnapshotMessage]
  type EC2SecurityGroupList = List[zio.aws.redshift.model.EC2SecurityGroup]
  type EligibleTracksToUpdateList = List[zio.aws.redshift.model.UpdateTarget]
  type EndpointAccesses = List[zio.aws.redshift.model.EndpointAccess]
  type EndpointAuthorizations =
    List[zio.aws.redshift.model.EndpointAuthorization]
  type EventCategoriesList = List[String]
  type EventCategoriesMapList = List[zio.aws.redshift.model.EventCategoriesMap]
  type EventInfoMapList = List[zio.aws.redshift.model.EventInfoMap]
  type EventList = List[zio.aws.redshift.model.Event]
  type EventSubscriptionsList = List[zio.aws.redshift.model.EventSubscription]
  type HsmClientCertificateList =
    List[zio.aws.redshift.model.HsmClientCertificate]
  type HsmConfigurationList = List[zio.aws.redshift.model.HsmConfiguration]
  type IPRangeList = List[zio.aws.redshift.model.IPRange]
  type IamRoleArnList = List[String]
  type ImportTablesCompleted = List[String]
  type ImportTablesInProgress = List[String]
  type ImportTablesNotStarted = List[String]
  type LogTypeList = List[String]
  type NetworkInterfaceList = List[zio.aws.redshift.model.NetworkInterface]
  type NodeConfigurationOptionList =
    List[zio.aws.redshift.model.NodeConfigurationOption]
  type NodeConfigurationOptionsFilterList =
    List[zio.aws.redshift.model.NodeConfigurationOptionsFilter]
  type OrderableClusterOptionsList =
    List[zio.aws.redshift.model.OrderableClusterOption]
  type ParameterGroupList = List[zio.aws.redshift.model.ClusterParameterGroup]
  type ParametersList = List[zio.aws.redshift.model.Parameter]
  type PartnerIntegrationInfoList =
    List[zio.aws.redshift.model.PartnerIntegrationInfo]
  type PendingActionsList = List[String]
  type RecurringChargeList = List[zio.aws.redshift.model.RecurringCharge]
  type ReservedNodeConfigurationOptionList =
    List[zio.aws.redshift.model.ReservedNodeConfigurationOption]
  type ReservedNodeExchangeStatusList =
    List[zio.aws.redshift.model.ReservedNodeExchangeStatus]
  type ReservedNodeList = List[zio.aws.redshift.model.ReservedNode]
  type ReservedNodeOfferingList =
    List[zio.aws.redshift.model.ReservedNodeOffering]
  type RestorableNodeTypeList = List[String]
  type RevisionTargetsList = List[zio.aws.redshift.model.RevisionTarget]
  type ScheduleDefinitionList = List[String]
  type ScheduledActionFilterList =
    List[zio.aws.redshift.model.ScheduledActionFilter]
  type ScheduledActionList = List[zio.aws.redshift.model.ScheduledAction]
  type ScheduledActionTimeList = List[TStamp]
  type ScheduledSnapshotTimeList = List[TStamp]
  type SnapshotCopyGrantList = List[zio.aws.redshift.model.SnapshotCopyGrant]
  type SnapshotIdentifierList = List[String]
  type SnapshotList = List[zio.aws.redshift.model.Snapshot]
  type SnapshotScheduleList = List[zio.aws.redshift.model.SnapshotSchedule]
  type SnapshotSortingEntityList =
    List[zio.aws.redshift.model.SnapshotSortingEntity]
  type SourceIdsList = List[String]
  type SubnetIdentifierList = List[String]
  type SubnetList = List[zio.aws.redshift.model.Subnet]
  type SupportedOperationList = List[zio.aws.redshift.model.SupportedOperation]
  type SupportedPlatformsList = List[zio.aws.redshift.model.SupportedPlatform]
  type TableRestoreStatusList = List[zio.aws.redshift.model.TableRestoreStatus]
  type TagKeyList = List[String]
  type TagList = List[zio.aws.redshift.model.Tag]
  type TagValueList = List[String]
  type TaggedResourceList = List[zio.aws.redshift.model.TaggedResource]
  type TrackList = List[zio.aws.redshift.model.MaintenanceTrack]
  type UsageLimits = List[zio.aws.redshift.model.UsageLimit]
  type ValueStringList = List[String]
  type VpcEndpointsList = List[zio.aws.redshift.model.VpcEndpoint]
  type VpcIdentifierList = List[String]
  type VpcSecurityGroupIdList = List[String]
  type VpcSecurityGroupMembershipList =
    List[zio.aws.redshift.model.VpcSecurityGroupMembership]
}
