package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyAquaConfigurationResponse(
    aquaConfiguration: Optional[zio.aws.redshift.model.AquaConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyAquaConfigurationResponse = {
    import ModifyAquaConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyAquaConfigurationResponse
      .builder()
      .optionallyWith(aquaConfiguration.map(value => value.buildAwsValue()))(
        _.aquaConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifyAquaConfigurationResponse.ReadOnly =
    zio.aws.redshift.model.ModifyAquaConfigurationResponse.wrap(buildAwsValue())
}
object ModifyAquaConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyAquaConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyAquaConfigurationResponse =
      zio.aws.redshift.model.ModifyAquaConfigurationResponse(
        aquaConfiguration.map(value => value.asEditable)
      )
    def aquaConfiguration
        : Optional[zio.aws.redshift.model.AquaConfiguration.ReadOnly]
    def getAquaConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.AquaConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("aquaConfiguration", aquaConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyAquaConfigurationResponse
  ) extends zio.aws.redshift.model.ModifyAquaConfigurationResponse.ReadOnly {
    override val aquaConfiguration
        : Optional[zio.aws.redshift.model.AquaConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aquaConfiguration())
        .map(value => zio.aws.redshift.model.AquaConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyAquaConfigurationResponse
  ): zio.aws.redshift.model.ModifyAquaConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
