package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{
  CustomDomainCertificateArnString,
  CustomDomainNameString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCustomDomainAssociationResponse(
    customDomainName: Optional[CustomDomainNameString] = Optional.Absent,
    customDomainCertificateArn: Optional[CustomDomainCertificateArnString] =
      Optional.Absent,
    clusterIdentifier: Optional[String] = Optional.Absent,
    customDomainCertExpiryTime: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateCustomDomainAssociationResponse = {
    import CreateCustomDomainAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateCustomDomainAssociationResponse
      .builder()
      .optionallyWith(
        customDomainName.map(value =>
          CustomDomainNameString.unwrap(value): java.lang.String
        )
      )(_.customDomainName)
      .optionallyWith(
        customDomainCertificateArn.map(value =>
          CustomDomainCertificateArnString.unwrap(value): java.lang.String
        )
      )(_.customDomainCertificateArn)
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(
        customDomainCertExpiryTime.map(value => value: java.lang.String)
      )(_.customDomainCertExpiryTime)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateCustomDomainAssociationResponse.ReadOnly =
    zio.aws.redshift.model.CreateCustomDomainAssociationResponse
      .wrap(buildAwsValue())
}
object CreateCustomDomainAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateCustomDomainAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.CreateCustomDomainAssociationResponse =
      zio.aws.redshift.model.CreateCustomDomainAssociationResponse(
        customDomainName.map(value => value),
        customDomainCertificateArn.map(value => value),
        clusterIdentifier.map(value => value),
        customDomainCertExpiryTime.map(value => value)
      )
    def customDomainName: Optional[CustomDomainNameString]
    def customDomainCertificateArn: Optional[CustomDomainCertificateArnString]
    def clusterIdentifier: Optional[String]
    def customDomainCertExpiryTime: Optional[String]
    def getCustomDomainName: ZIO[Any, AwsError, CustomDomainNameString] =
      AwsError.unwrapOptionField("customDomainName", customDomainName)
    def getCustomDomainCertificateArn
        : ZIO[Any, AwsError, CustomDomainCertificateArnString] =
      AwsError.unwrapOptionField(
        "customDomainCertificateArn",
        customDomainCertificateArn
      )
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getCustomDomainCertExpiryTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "customDomainCertExpiryTime",
        customDomainCertExpiryTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateCustomDomainAssociationResponse
  ) extends zio.aws.redshift.model.CreateCustomDomainAssociationResponse.ReadOnly {
    override val customDomainName: Optional[CustomDomainNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDomainName())
        .map(value =>
          zio.aws.redshift.model.primitives.CustomDomainNameString(value)
        )
    override val customDomainCertificateArn
        : Optional[CustomDomainCertificateArnString] = zio.aws.core.internal
      .optionalFromNullable(impl.customDomainCertificateArn())
      .map(value =>
        zio.aws.redshift.model.primitives
          .CustomDomainCertificateArnString(value)
      )
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val customDomainCertExpiryTime: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDomainCertExpiryTime())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateCustomDomainAssociationResponse
  ): zio.aws.redshift.model.CreateCustomDomainAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
