package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MaintenanceTrack(
    maintenanceTrackName: Optional[String] = Optional.Absent,
    databaseVersion: Optional[String] = Optional.Absent,
    updateTargets: Optional[Iterable[zio.aws.redshift.model.UpdateTarget]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.MaintenanceTrack = {
    import MaintenanceTrack.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.MaintenanceTrack
      .builder()
      .optionallyWith(
        maintenanceTrackName.map(value => value: java.lang.String)
      )(_.maintenanceTrackName)
      .optionallyWith(databaseVersion.map(value => value: java.lang.String))(
        _.databaseVersion
      )
      .optionallyWith(
        updateTargets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.updateTargets)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.MaintenanceTrack.ReadOnly =
    zio.aws.redshift.model.MaintenanceTrack.wrap(buildAwsValue())
}
object MaintenanceTrack {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.MaintenanceTrack
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.MaintenanceTrack =
      zio.aws.redshift.model.MaintenanceTrack(
        maintenanceTrackName.map(value => value),
        databaseVersion.map(value => value),
        updateTargets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def maintenanceTrackName: Optional[String]
    def databaseVersion: Optional[String]
    def updateTargets
        : Optional[List[zio.aws.redshift.model.UpdateTarget.ReadOnly]]
    def getMaintenanceTrackName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceTrackName", maintenanceTrackName)
    def getDatabaseVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseVersion", databaseVersion)
    def getUpdateTargets: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.UpdateTarget.ReadOnly
    ]] = AwsError.unwrapOptionField("updateTargets", updateTargets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.MaintenanceTrack
  ) extends zio.aws.redshift.model.MaintenanceTrack.ReadOnly {
    override val maintenanceTrackName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maintenanceTrackName())
      .map(value => value: String)
    override val databaseVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseVersion())
      .map(value => value: String)
    override val updateTargets
        : Optional[List[zio.aws.redshift.model.UpdateTarget.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateTargets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.UpdateTarget.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.MaintenanceTrack
  ): zio.aws.redshift.model.MaintenanceTrack.ReadOnly = new Wrapper(impl)
}
