package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{IntegerOptional, BooleanOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeEndpointAuthorizationRequest(
    clusterIdentifier: Optional[String] = Optional.Absent,
    account: Optional[String] = Optional.Absent,
    grantee: Optional[BooleanOptional] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest = {
    import DescribeEndpointAuthorizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(account.map(value => value: java.lang.String))(_.account)
      .optionallyWith(grantee.map(value => value: java.lang.Boolean))(_.grantee)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeEndpointAuthorizationRequest.ReadOnly =
    zio.aws.redshift.model.DescribeEndpointAuthorizationRequest
      .wrap(buildAwsValue())
}
object DescribeEndpointAuthorizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeEndpointAuthorizationRequest =
      zio.aws.redshift.model.DescribeEndpointAuthorizationRequest(
        clusterIdentifier.map(value => value),
        account.map(value => value),
        grantee.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def clusterIdentifier: Optional[String]
    def account: Optional[String]
    def grantee: Optional[BooleanOptional]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getAccount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("account", account)
    def getGrantee: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("grantee", grantee)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest
  ) extends zio.aws.redshift.model.DescribeEndpointAuthorizationRequest.ReadOnly {
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val account: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.account())
      .map(value => value: String)
    override val grantee: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.grantee())
      .map(value => value: BooleanOptional)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest
  ): zio.aws.redshift.model.DescribeEndpointAuthorizationRequest.ReadOnly =
    new Wrapper(impl)
}
