package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{
  IntegerOptional,
  CustomDomainCertificateArnString,
  CustomDomainNameString
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeCustomDomainAssociationsRequest(
    customDomainName: Optional[CustomDomainNameString] = Optional.Absent,
    customDomainCertificateArn: Optional[CustomDomainCertificateArnString] =
      Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsRequest = {
    import DescribeCustomDomainAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsRequest
      .builder()
      .optionallyWith(
        customDomainName.map(value =>
          CustomDomainNameString.unwrap(value): java.lang.String
        )
      )(_.customDomainName)
      .optionallyWith(
        customDomainCertificateArn.map(value =>
          CustomDomainCertificateArnString.unwrap(value): java.lang.String
        )
      )(_.customDomainCertificateArn)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeCustomDomainAssociationsRequest.ReadOnly =
    zio.aws.redshift.model.DescribeCustomDomainAssociationsRequest
      .wrap(buildAwsValue())
}
object DescribeCustomDomainAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeCustomDomainAssociationsRequest =
      zio.aws.redshift.model.DescribeCustomDomainAssociationsRequest(
        customDomainName.map(value => value),
        customDomainCertificateArn.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def customDomainName: Optional[CustomDomainNameString]
    def customDomainCertificateArn: Optional[CustomDomainCertificateArnString]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getCustomDomainName: ZIO[Any, AwsError, CustomDomainNameString] =
      AwsError.unwrapOptionField("customDomainName", customDomainName)
    def getCustomDomainCertificateArn
        : ZIO[Any, AwsError, CustomDomainCertificateArnString] =
      AwsError.unwrapOptionField(
        "customDomainCertificateArn",
        customDomainCertificateArn
      )
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsRequest
  ) extends zio.aws.redshift.model.DescribeCustomDomainAssociationsRequest.ReadOnly {
    override val customDomainName: Optional[CustomDomainNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDomainName())
        .map(value =>
          zio.aws.redshift.model.primitives.CustomDomainNameString(value)
        )
    override val customDomainCertificateArn
        : Optional[CustomDomainCertificateArnString] = zio.aws.core.internal
      .optionalFromNullable(impl.customDomainCertificateArn())
      .map(value =>
        zio.aws.redshift.model.primitives
          .CustomDomainCertificateArnString(value)
      )
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsRequest
  ): zio.aws.redshift.model.DescribeCustomDomainAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
