package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CertificateAssociation(
    customDomainName: Optional[String] = Optional.Absent,
    clusterIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CertificateAssociation = {
    import CertificateAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CertificateAssociation
      .builder()
      .optionallyWith(customDomainName.map(value => value: java.lang.String))(
        _.customDomainName
      )
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.CertificateAssociation.ReadOnly =
    zio.aws.redshift.model.CertificateAssociation.wrap(buildAwsValue())
}
object CertificateAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CertificateAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CertificateAssociation =
      zio.aws.redshift.model.CertificateAssociation(
        customDomainName.map(value => value),
        clusterIdentifier.map(value => value)
      )
    def customDomainName: Optional[String]
    def clusterIdentifier: Optional[String]
    def getCustomDomainName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customDomainName", customDomainName)
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CertificateAssociation
  ) extends zio.aws.redshift.model.CertificateAssociation.ReadOnly {
    override val customDomainName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.customDomainName())
      .map(value => value: String)
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CertificateAssociation
  ): zio.aws.redshift.model.CertificateAssociation.ReadOnly = new Wrapper(impl)
}
