package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateDataShareConsumerRequest(
    dataShareArn: String,
    associateEntireAccount: Optional[BooleanOptional] = Optional.Absent,
    consumerArn: Optional[String] = Optional.Absent,
    consumerRegion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AssociateDataShareConsumerRequest = {
    import AssociateDataShareConsumerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AssociateDataShareConsumerRequest
      .builder()
      .dataShareArn(dataShareArn: java.lang.String)
      .optionallyWith(
        associateEntireAccount.map(value => value: java.lang.Boolean)
      )(_.associateEntireAccount)
      .optionallyWith(consumerArn.map(value => value: java.lang.String))(
        _.consumerArn
      )
      .optionallyWith(consumerRegion.map(value => value: java.lang.String))(
        _.consumerRegion
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.AssociateDataShareConsumerRequest.ReadOnly =
    zio.aws.redshift.model.AssociateDataShareConsumerRequest
      .wrap(buildAwsValue())
}
object AssociateDataShareConsumerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AssociateDataShareConsumerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.AssociateDataShareConsumerRequest =
      zio.aws.redshift.model.AssociateDataShareConsumerRequest(
        dataShareArn,
        associateEntireAccount.map(value => value),
        consumerArn.map(value => value),
        consumerRegion.map(value => value)
      )
    def dataShareArn: String
    def associateEntireAccount: Optional[BooleanOptional]
    def consumerArn: Optional[String]
    def consumerRegion: Optional[String]
    def getDataShareArn: ZIO[Any, Nothing, String] = ZIO.succeed(dataShareArn)
    def getAssociateEntireAccount: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "associateEntireAccount",
        associateEntireAccount
      )
    def getConsumerArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("consumerArn", consumerArn)
    def getConsumerRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("consumerRegion", consumerRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AssociateDataShareConsumerRequest
  ) extends zio.aws.redshift.model.AssociateDataShareConsumerRequest.ReadOnly {
    override val dataShareArn: String = impl.dataShareArn(): String
    override val associateEntireAccount: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associateEntireAccount())
        .map(value => value: BooleanOptional)
    override val consumerArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.consumerArn())
      .map(value => value: String)
    override val consumerRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.consumerRegion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AssociateDataShareConsumerRequest
  ): zio.aws.redshift.model.AssociateDataShareConsumerRequest.ReadOnly =
    new Wrapper(impl)
}
